#pragma rtGlobals=1		// Use modern global access method.
//	Adapted From Bernardo Sabatini
// 	Modifications
//		1. 	Works under Igor Version 2.01
//		2.	All frequencies specified in Hz, not kHz
//		3.	Internally treats waves using double precision math, returns single precision result
//		4.	All functions are compiled w/o use of "execute" commands.  This runs faster.
//		5.	Multiplication by transfer function is coerced to use complex arithmetic.
//			This avoids compile time assumption of real arithmetic.

function mi_LowPassFilter (InputWave, CutOffFreq, NumPoles)
	wave		InputWave
	variable	CutOffFreq					// 	Now in Hz, not kHz!
	variable	NumPoles
	
	duplicate 	/D/o InputWave temp_w	
	mi_PrepareWaveForFFT (temp_w)
	mi_FilterInSitu (temp_w, 0, CutOffFreq, NumPoles)
	duplicate /o temp_w $(nameofwave(InputWave)+"_F"+num2str(CutOffFreq))
	killwaves temp_w
end		


function  mi_DeConvolve (ConvolveWave,OutputWave,CutOffFreq, NumPoles)
	wave		OutputWave
	wave 		ConvolveWave
	variable	CutOffFreq					// 	Now in Hz, not kHz!
	variable	NumPoles

	duplicate 	/D/O OutputWave, temp_w1
	duplicate 	/D/O ConvolveWave, temp_w2
	Redimension/N=(numpnts(OutputWave))temp_w2
	mi_PrepareWaveForFFT (temp_w1)
	mi_PrepareWaveForFFT (temp_w2)
	fft temp_w1	
	fft temp_w2
	duplicate /D/O/C temp_w1  temp_cmplx				//  kluge to force multiplication to use complex algebra
	duplicate /O/C/D temp_cmplx temp_fil					// create wave for filter transfer function
	mi_BuildFilterTransferFunction (temp_fil, 0, CutOffFreq, NumPoles)
	temp_cmplx = temp_w1/temp_w2*temp_fil
	ifft temp_cmplx										// take inverse FFT to return to time domain
	duplicate /s/o temp_cmplx $("D_"+nameofwave(ConvolveWave)+"_"+nameofwave(OutputWave))
end		

function mi_FastFilter (InputWave, HighCutOffFreq, NumPoles)
	wave		InputWave
	variable	HighCutOffFreq		// Now in Hz, not kHz!
	variable	NumPoles
	
	mi_FastBPFilter (InputWave, 0, HighCutOffFreq, NumPoles)
end


function mi_FastBPFilter (InputWave, LowCutOffFreq, HighCutOffFreq, NumPoles)
	wave		InputWave
	variable	LowCutOffFreq, HighCutOffFreq		// Now in Hz, not kHz!
	variable	NumPoles
	variable	oldpnts
	
	if ((lowcutofffreq == 0) %& (highcutofffreq == 0))	// i.e. don't want to filter
		return 0
	endif
	oldpnts = numpnts (inputwave)
	mi_PrepareWaveForFFT (InputWave)
	mi_FilterInSitu (InputWave, LowCutOffFreq, HighCutOffFreq, NumPoles)
	redimension /s/n=(oldpnts) InputWave
end		

function mi_FilterInSitu	(InputWave,LowCutOffFreq, HighCutOffFreq, NumPoles)
	wave		InputWave
	variable 	LowCutOffFreq, HighCutOffFreq
	variable	NumPoles
	variable	oldx
	
	oldx = leftx (inputwave)
	duplicate	/O/D	InputWave, temp_double
	fft	temp_double										// take FFT to convert to freq. domain
	duplicate /O/C/D temp_double temp_fil					// create wave for filter transfer function
	mi_BuildFilterTransferFunction (temp_fil, LowCutOffFreq, HighCutOffFreq, NumPoles)
	duplicate	/D/o/c temp_double  temp_cmplx			//	KLUGE to force multiplication to use complex algebra
	temp_cmplx *= temp_fil
	ifft temp_cmplx										// take inverse FFT to return to time domain
	duplicate	/S/O	temp_cmplx, InputWave
	KillWaves	temp_double, temp_cmplx, temp_fil
	SetScale/P x oldx,deltax(inputwave), inputwave
end		


function	mi_PrepareWaveForFFT (W)
	wave	/D	W
	mi_AdjustNumberofPoints (W)			//	Adjusts wave dimensioning to 2^n points for FFT
	mi_ConvertNaNs(W)					// 	Converts all NaNs to zeros
end


function	mi_AdjustNumberofPoints (W)
	wave		/D	w
	variable	num_bits, num_points
	variable	/D	factor
	
	factor = 1/(log(2))
	num_bits = factor * log (numpnts (W))
	num_points = 2 ^ (ceil (num_bits))
	redimension /D/n=(num_points) W
end

Function mi_ConvertNaNs(theWave)
	Wave		/D		theWave 
	Variable 	p, numPoints
	Variable	 val
	// numNaNs = 0
	wavestats /q thewave
	if (V_numNans != 0)
		p = 0											// the loop index
		numPoints = numpnts(theWave)				// number of times to loop
		do
			val = theWave[p]
			if (numtype(val)==2)						// is this NaN?
				theWave[p] = 0
			endif
			p += 1
		while (p < numPoints)
	endif
End


function mi_BuildFilterTransferFunction (W, LowCutOffFreq, HighCutOffFreq,NumPoles)
	wave /D/c		W
	variable	LowCutOffFreq, HighCutOffFreq				// in Hz
	variable	NumPoles
	redimension /D/r W				// throw away imag. part of complex wave
	wave	wr = W
	
	if ((LowCutOffFreq == 0) %& (HighCutOffFreq > 0))
		wr = 1/(1+(x/(HighCutOffFreq))^NumPoles)
		return 0
	endif
	if ((LowCutOffFreq > 0) %& (HighCutOffFreq == 0))
		wr = 1 - 1/(1+(x/(LowCutoffFreq))^NumPoles)
		return 0
	endif
	if ((LowCutOffFreq > 0) %& (HighCutOffFreq > 0) %& (HighCutOffFreq > LowCutOffFreq))
		wr = 1/(1+(x/(HighCutOffFreq))^NumPoles) * (1 - 1/(1+(x/(LowCutoffFreq))^NumPoles))
		return 0
	endif
	wr = 1
end

function mi_FasterBPFilter (w, LowCutOffFreq, HighCutoffFreq, NumPoles)
	wave		w
	variable	LowCutOffFreq, HighCutOffFreq		// Now in Hz, not kHz!
	variable	NumPoles
	variable	oldpnts, oldx
	
	if ((lowcutofffreq == 0) %& (highcutofffreq == 0))	// i.e. don't want to filter
		return 0
	endif
	
	oldpnts = numpnts (w)				// preserve original leftx and numpnts (messed up by FFT)
	oldx = leftx (w)
	redimension /D/n=(2 ^ (ceil (log (oldpnts)/log(2)))) w	// i.e. adjust # of points to power of 2
	fft w

	// do we need to recreate filter function?
	if (!exists ("mi_filterSpecs"))
		make /n=4 mi_filterSpecs
		mi_filterSpecs = nan
	endif
	if ((lowcutofffreq != mi_filterspecs[0]) %| (highcutofffreq != mi_filterspecs[1]) %| (numpoles != mi_filterspecs[2]) %| (numpnts (w) != mi_filterspecs[3]))
		mi_filterspecs = {lowcutofffreq, highcutofffreq, numpoles, numpnts (w)}
		duplicate /o/c/d w mi_filterFunc
		mi_BuildFilterTransferFunction (mi_filterFunc, LowCutOffFreq, HighCutOffFreq, NumPoles)
	endif
	execute nameofwave (w) +" *= mi_filterFunc"	//	KLUGE to force multiplication to use complex algebra
	
	// put back in time domain and clean up scaling, etc.
	ifft w
	redimension /s/n=(oldpnts) w
	SetScale/P x oldx,deltax(w), w
end		
